define([
    'underscore',
    'backbone',
    'marionette',
    'App',
    'text!modules/new-appointment-request/views/direct/clinics/templates/single-clinic.html',
    'text!modules/new-appointment-request/views/direct/clinics/templates/_clinic_template.html',
    'modules/new-appointment-request/resources/direct/preferred-date/clinics-time-slots-collections',
    'modules/new-appointment-request/views/direct/no-timeslots-popup/error-message',
    'modules/new-appointment-request/resources/constants',
],
function(
    _,
    Backbone,
    Marionette,
    app,
    singleClinicTemplate,
    _clinicTemplate,
    SlotsCollection,
    NoAppointmentError,
    constants
) {
    'use strict';

    return Marionette.View.extend({
        template: singleClinicTemplate,
        initialize: function(options) {
            var messageModel = options.clinicCustomMessage;
            var messageText = messageModel instanceof Backbone.Model ? messageModel.get('messageText') : '';
            this.clinicsTimeSlotsModel = options.clinicsTimeSlotsModel;
            this.customMessageText = messageText;
            this.slots = new SlotsCollection();
            this.checkClinic(this.clinicsTimeSlotsModel);
        },

        /**
             * @param {Backbone.Model} model
             * @return {void}
             */
        checkClinic: function(model) {
            var slots = new SlotsCollection();
            var id = model.get('clinicId');
            var siteCode = this.model.getSiteCode();

            this.slots = slots;
            this.model.unset('clinic');
            this.listenToOnce(this.slots, 'fetch:success', this.fetchSlotsSuccess);

            this.slots.fetchData(siteCode, id);
        },

        fetchSlotsSuccess: function(collection) {
            var model = collection.first() || new Backbone.Model();
            var slots = model.get('appointmentTimeSlot') || [];
            if (slots.length) {
                return this.model.set('clinic', this.clinicsTimeSlotsModel);
            }
            this.showErrorMessage();
            return null;
        },

        // TODO we are doubling down on some function in multi clinic view that does the same thing
        getTimeSlots: function(clinicId) {
            if (this.slots) {
                return this.slots.get(clinicId);
            }
            return null;
        },

        showErrorMessage: function() {
            var popup = new NoAppointmentError({elAfterClose: this.$('legend:first')});
            popup.openPopup();
        },

        templateContext: function() {
            if (!this.clinicTemplate) {
                this.clinicTemplate = _.template(_clinicTemplate);
            }

            return {
                customMessageText: this.customMessageText,
                clinic: this.clinicTemplate,
                clinicName: this.clinicsTimeSlotsModel.getClinicName(),
                friendlyName: this.clinicsTimeSlotsModel.getFriendlyLocationName(),
                secondaryStopCode: this.clinicsTimeSlotsModel.get('secondaryStopCode'),
                VIDEO_STOP_CODE: constants.VIDEO_STOP_CODE,
                isTelehealthFeaturesEnabled: _.isUndefined(app.disabledFeatures.get('TH_FEATURE_SET')),
            };
        },
    });
});
